<?php

/**
 * Test class for WSUtilityService.
 * Generated by PHPUnit on 2012-06-14 at 10:31:59.
 * @group WebServices
 */
class WSUtilityServiceTest extends PHPUnit_Framework_TestCase {

    /**
     * @var WSUtilityService
     */
    protected $service;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->service = new WSUtilityService();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        
    }

    /**
     * @covers WSUtilityService::getWSUtilityDao
     */
    public function testGetWSUtilityDao() {
        $result = $this->service->getWSUtilityDao();
        $this->assertTrue($result instanceof WSUtilityDao);
        
        $newDao = new WSUtilityDao();
        $this->service->setWSUtilityDao($newDao);
        $this->assertEquals($newDao, $this->service->getWSUtilityDao());
    }

    /**
     * @covers WSUtilityService::setWSUtilityDao
     */
    public function testSetWSUtilityDao() {
        $dao = new WSUtilityDao();
        $this->service->setWSUtilityDao($dao);
        $this->assertEquals($dao, $this->service->getWSUtilityDao());
    }

    /**
     * @covers WSUtilityService::format
     */
    public function testFormat() {
        $collection = array(1, 'a', 3, 'c');
        $expected = '[1,"a",3,"c"]';
        $result = $this->service->format($collection, WSHelper::FORMAT_JSON);
        $this->assertEquals($expected, $result);
    }

}

