<?php

/**
 * Test class for WSManager.
 * Generated by PHPUnit on 2012-06-13 at 09:47:17.
 * @group WebServices
 */
class WSManagerTest extends PHPUnit_Framework_TestCase {

    public static function setupBeforeClass() {
        WSManager::resetConfiguration();
    }

    /**
     * @var WSManager
     */
    protected $manager;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {
        $this->manager = new WSManager();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {
        
    }

    /**
     * @covers WSManager::isMethodAvailable
     */
    public function testIsMethodAvailable() {
        $this->manager->setPluginsDirectoryPath(dirname(__FILE__) . '/../../testPluginDirectoryStructure/');
        $this->assertTrue($this->manager->isMethodAvailable('methodA', 'GET'));
        $this->assertTrue($this->manager->isMethodAvailable('methodD', 'GET'));
        $this->assertFalse($this->manager->isMethodAvailable('methodX', 'GET'));
    }

    /**
     * @covers WSManager::callMethod
     * @todo Implement testCallMethod().
     * 
     */
    public function testCallMethod() {
        $paramObj = new WSRequestParameters();
        $paramObj->setAppId(1);
        $paramObj->setAppToken('1234567890');
        $paramObj->setMethod('exampleMethod');
        $paramObj->setSessionToken(uniqid('ohrm_ws_session_'));
        $paramObj->setParameters(array());
        $paramObj->setRequestMethod('GET');

        $result = $this->manager->callMethod($paramObj);
        $this->assertNotNull($result);
    }

    /**
     * @covers  WSManager::getPluginsDirectoryPath
     */
    public function testGetPluginsDirectoryPath() {
        $pluginsDirectoryPath = $this->manager->getPluginsDirectoryPath();
        $this->assertEquals(sfConfig::get('sf_plugins_dir'), $pluginsDirectoryPath);
        
        $this->manager->setPluginsDirectoryPath('../../plugins/');
        $pluginsDirectoryPath = $this->manager->getPluginsDirectoryPath();
        $this->assertEquals('../../plugins/', $pluginsDirectoryPath);
    }

    /**
     * @covers  WSManager::setPluginsDirectoryPath
     */
    public function testSetPluginsDirectoryPath() {
        $this->manager->setPluginsDirectoryPath('../../plugins/');
        $pluginsDirectoryPath = $this->manager->getPluginsDirectoryPath();
        $this->assertEquals('../../plugins/', $pluginsDirectoryPath);
    }

    /**
     * @covers  WSManager::getConfigurations
     */
    public function testGetConfigurations() {
        $this->manager->setPluginsDirectoryPath(dirname(__FILE__) . '/../../testPluginDirectoryStructure/');
        $expected = array(
            'methods' => array(
                'methodA' => array(
                    'wrapper' => 'ClassA',
                    'group' => 'test1',
                    'type' => 'GET',
                ),
                'exampleMethod' => array(
                    'wrapper' => 'ExampleServiceWrapper',
                    'group' => 'test2',
                    'type' => 'GET',
                ),
                'methodC' => array(
                    'wrapper' => 'ClassC',
                    'group' => 'test1',
                    'type' => 'GET',
                ),
                'methodD' => array(
                    'wrapper' => 'ClassD',
                    'group' => 'test2',
                    'type' => 'GET',
                ),
            ),
        );

        $result = $this->manager->getConfigurations();
        $this->assertEquals($expected, $result);
    }

}
