<?php
/**
 * This file generate the hidden inputs required by the ajax process.
 * If a step is defined in the url's getters, then we parse it in an hidden input
 * comfortupdate.js will check this hidden input, and load the correct step.
 * Most steps also need to know the destination build
 */


 /**
  *
  * IN 2.06, those input MUST be generated by the globalsettings controller.
  * Test UPDATE
  */
$p = new CHtmlPurifier();
/* The Purifier makes not mucg sense as it does not really prevent SQL injection */
?>

<script>
    var csrf_token_name = "<?php echo sanitize_paranoid_string(Yii::app()->request->csrfTokenName);?>";
    var csrf_token = "<?php echo htmlspecialchars(Yii::app()->request->csrfToken);?>";
</script>

<?php if(isset($_REQUEST['update'])):?>
    <?php echo CHtml::hiddenField('update_step',$p->purify($_REQUEST['update']),array('id'=>'update_step'));?>
<?php else:?>
    <?php echo CHtml::hiddenField('update_step','',array('id'=>'update_step'));?>
<?php endif;?>

<?php if(isset($_REQUEST['destinationBuild'])):?>
    <?php echo CHtml::hiddenField('destinationBuildForAjax',(int)$_REQUEST['destinationBuild'],array('id'=>'destinationBuildForAjax'));?>
<?php endif;?>

<?php if(isset($_REQUEST['access_token'])):?>
    <?php echo CHtml::hiddenField('access_tokenForAjax',$p->purify($_REQUEST['access_token']),array('id'=>'access_tokenForAjax'));?>
<?php endif;?>

 <input id="updatebothbranchdatas" type="hidden" data-url="<?php echo Yii::app()->createUrl("admin/update/sa/getbothbuttons"); ?>"/>
 <input id="updatestrablebranchdatas" type="hidden" data-url="<?php echo Yii::app()->createUrl("admin/update/sa/getstablebutton"); ?>"/>

 <input id="newkeyurl" type="hidden" data-url="<?php echo Yii::app()->createUrl("admin/update/sa/getnewkey"); ?>"/>
 <input id="filesystemurl" type="hidden" data-url="<?php echo Yii::app()->createUrl("admin/update/sa/fileSystem"); ?>"/>
 <input id="checklocalerrorsurl" type="hidden" data-url="<?php echo Yii::app()->createUrl("admin/update/sa/checkLocalErrors"); ?>"/>
 <input id="welcomeurl" type="hidden" data-url="<?php echo Yii::app()->createUrl("admin/update/sa/getwelcome"); ?>"/>
<input id="localerrormsg" type="hidden" data-message="<?php echo eT('You have an error inside your local installation of LimeSurvey. See:');?>" />
